<?php

namespace App\Controllers;

use App\Models\DistrictModel;
use App\Models\AnganwadiNamesModel;
use App\Models\MonthlyOutreachDataModel;
use App\Models\Children0m6mModel;

class Home extends BaseController
{
    public function index(): string
    {
        $districtModel = new DistrictModel();
        $data['districts'] = $districtModel->getAllDistricts();
        
        return view('home', $data);
    }

    // Get anganwadi centers by district ID
    public function getAnganwadiByDistrict()
    {
        $districtId = $this->request->getPost('district_id');
        
        if (!$districtId) {
            return $this->response->setJSON([]);
        }

        $anganwadiModel = new AnganwadiNamesModel();
        $anganwadis = $anganwadiModel->getByDistrictId($districtId);

        return $this->response->setJSON($anganwadis);
    }

    // Get children data by anganwadi center code
    public function getChildrenData()
    {
        $awcCode = $this->request->getPost('awc_code');
        
        if (!$awcCode) {
            return $this->response->setJSON([
                'outreach_data' => [],
                'children_data' => []
            ]);
        }

        // Get monthly outreach data
        $outreachModel = new MonthlyOutreachDataModel();
        $outreachData = $outreachModel->where('anganwadi_center_code', $awcCode)->findAll();

        // Get children data
        $childrenModel = new Children0m6mModel();
        $childrenData = $childrenModel->getByAwcCode($awcCode);

        return $this->response->setJSON([
            'outreach_data' => $outreachData,
            'children_data' => $childrenData
        ]);
    }
}
