<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class CreateDistrictTable extends Migration
{
    public function up()
    {
        $this->forge->addField([
            'id' => [
                'type'           => 'INT',
                'constraint'     => 11,
                'unsigned'       => true,
                'auto_increment' => true,
            ],
            'district_id' => [
                'type'       => 'INT',
                'constraint' => 11,
                'unsigned'   => true,
            ],
            'district_name' => [
                'type'       => 'VARCHAR',
                'constraint' => '255',
            ],
        ]);
        
        $this->forge->addKey('id', true);
        $this->forge->createTable('district');
    }

    public function down()
    {
        $this->forge->dropTable('district');
    }
}
