<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class CreateAnganwadiNamesTable extends Migration
{
    public function up()
    {
        $this->forge->addField([
            'id' => [
                'type'           => 'INT',
                'constraint'     => 11,
                'unsigned'       => true,
                'auto_increment' => true,
            ],
            'district_id' => [
                'type'       => 'INT',
                'constraint' => 11,
                'unsigned'   => true,
            ],
            'awc_center_code' => [
                'type'       => 'VARCHAR',
                'constraint' => '20',
            ],
            'name' => [
                'type'       => 'VARCHAR',
                'constraint' => '255',
            ],
        ]);
        
        $this->forge->addKey('id', true);
        $this->forge->createTable('anganwadi_names');
    }

    public function down()
    {
        $this->forge->dropTable('anganwadi_names');
    }
}
