<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class CreateMonthlyOutreachDataTable extends Migration
{
    public function up()
    {
        $this->forge->addField([
            'id' => [
                'type'           => 'INT',
                'constraint'     => 11,
                'unsigned'       => true,
                'auto_increment' => true,
            ],
            'anganwadi_center_code' => [
                'type'       => 'VARCHAR',
                'constraint' => '16',
            ],
            'awc_worker_name' => [
                'type'       => 'VARCHAR',
                'constraint' => '32',
            ],
            'address_of_new_locations' => [
                'type'       => 'VARCHAR',
                'constraint' => '128',
            ],
            'building_type' => [
                'type'       => 'VARCHAR',
                'constraint' => '32',
            ],
            'location_area' => [
                'type'       => 'VARCHAR',
                'constraint' => '8',
                'null'       => true,
            ],
            'month_year' => [
                'type'       => 'VARCHAR',
                'constraint' => '8',
            ],
            'created_at' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'updated_at' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
        ]);
        
        $this->forge->addKey('id', true);
        $this->forge->createTable('monthly_outreach_data');
    }

    public function down()
    {
        $this->forge->dropTable('monthly_outreach_data');
    }
}
