<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class CreateChildren6m3yTable extends Migration
{
    public function up()
    {
        $this->forge->addField([
            'child_Id' => [
                'type'           => 'INT',
                'constraint'     => 11,
                'auto_increment' => true,
            ],
            'aadhar_flag' => [
                'type'       => 'CHAR',
                'constraint' => '1',
                'null'       => true,
            ],
            'aadhar_verified' => [
                'type'       => 'VARCHAR',
                'constraint' => '50',
                'null'       => true,
            ],
            'awc_id' => [
                'type'       => 'INT',
                'constraint' => 11,
                'null'       => true,
            ],
            'awc_name' => [
                'type'       => 'VARCHAR',
                'constraint' => '255',
                'null'       => true,
            ],
            'beneficiary_type' => [
                'type'       => 'VARCHAR',
                'constraint' => '50',
                'null'       => true,
            ],
            'category' => [
                'type'       => 'VARCHAR',
                'constraint' => '50',
                'null'       => true,
            ],
            'district_id' => [
                'type'       => 'INT',
                'constraint' => 11,
                'null'       => true,
            ],
            'dob' => [
                'type' => 'DATE',
                'null' => true,
            ],
            'father_name' => [
                'type'       => 'VARCHAR',
                'constraint' => '255',
                'null'       => true,
            ],
            'gender' => [
                'type'       => 'CHAR',
                'constraint' => '1',
                'null'       => true,
            ],
            'id' => [
                'type'       => 'INT',
                'constraint' => 11,
                'null'       => true,
            ],
            'mobile_no' => [
                'type'       => 'VARCHAR',
                'constraint' => '20',
                'null'       => true,
            ],
            'mobile_verified' => [
                'type'       => 'VARCHAR',
                'constraint' => '50',
                'null'       => true,
            ],
            'mother_name' => [
                'type'       => 'VARCHAR',
                'constraint' => '255',
                'null'       => true,
            ],
            'name' => [
                'type'       => 'VARCHAR',
                'constraint' => '255',
                'null'       => true,
            ],
            'project_id' => [
                'type'       => 'INT',
                'constraint' => 11,
                'null'       => true,
            ],
            'sector_id' => [
                'type'       => 'INT',
                'constraint' => 11,
                'null'       => true,
            ],
            'sector_name' => [
                'type'       => 'VARCHAR',
                'constraint' => '255',
                'null'       => true,
            ],
            'state_id' => [
                'type'       => 'INT',
                'constraint' => 11,
                'null'       => true,
            ],
            'updated_at' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'ProjectName' => [
                'type'       => 'VARCHAR',
                'constraint' => '255',
                'null'       => true,
            ],
            'DistrictName' => [
                'type'       => 'VARCHAR',
                'constraint' => '255',
                'null'       => true,
            ],
            'awc_code' => [
                'type'       => 'VARCHAR',
                'constraint' => '255',
                'null'       => true,
            ],
            'abha_address' => [
                'type'       => 'VARCHAR',
                'constraint' => '255',
                'null'       => true,
            ],
            'abha_id' => [
                'type'       => 'VARCHAR',
                'constraint' => '255',
                'null'       => true,
            ],
            'snp_opt_out' => [
                'type'       => 'VARCHAR',
                'constraint' => '10',
                'null'       => true,
            ],
            'snp_opt_out_date' => [
                'type'       => 'VARCHAR',
                'constraint' => '50',
                'null'       => true,
            ],
            'uid_hash' => [
                'type'       => 'VARCHAR',
                'constraint' => '255',
                'null'       => true,
            ],
            'monthupdated' => [
                'type'       => 'VARCHAR',
                'constraint' => '255',
                'null'       => true,
            ],
            'yearupdated' => [
                'type'       => 'VARCHAR',
                'constraint' => '255',
                'null'       => true,
            ],
            'ProjectCode' => [
                'type'       => 'VARCHAR',
                'constraint' => '255',
                'null'       => true,
            ],
            'age_in_months' => [
                'type'       => 'INT',
                'constraint' => 11,
                'null'       => true,
            ],
            'encrypted_mobile' => [
                'type'       => 'VARCHAR',
                'constraint' => '255',
                'null'       => true,
            ],
            'encrypted_u_id' => [
                'type'       => 'VARCHAR',
                'constraint' => '255',
                'null'       => true,
            ],
            'birth_weight' => [
                'type'       => 'DECIMAL',
                'constraint' => '5,2',
                'null'       => true,
            ],
            'current_weight' => [
                'type'       => 'DECIMAL',
                'constraint' => '5,2',
                'null'       => true,
            ],
            'weight_captured_date' => [
                'type' => 'DATE',
                'null' => true,
            ],
            'face_verified' => [
                'type'       => 'VARCHAR',
                'constraint' => '255',
                'null'       => true,
            ],
        ]);
        
        // Primary key
        $this->forge->addKey('child_Id', true);
        
        $this->forge->createTable('children_6m_3y');
        
        // Add indexes with length prefixes using raw SQL
        $db = \Config\Database::connect();
        
        $db->query('ALTER TABLE `children_6m_3y` ADD INDEX `ProjectCode_monthupdated_yearupdated_age_in_months` (`ProjectCode`(50), `monthupdated`(50), `yearupdated`(50), `age_in_months`)');
        $db->query('ALTER TABLE `children_6m_3y` ADD INDEX `idx_project_month_year` (`ProjectCode`(50), `monthupdated`(50), `yearupdated`(50))');
        $db->query('ALTER TABLE `children_6m_3y` ADD INDEX `idx_project_age` (`ProjectName`(50), `age_in_months`)');
        $db->query('ALTER TABLE `children_6m_3y` ADD INDEX `idx_month_year_age` (`monthupdated`(50), `yearupdated`(50), `age_in_months`)');
        $db->query('ALTER TABLE `children_6m_3y` ADD INDEX `idx_district_Id_month_year` (`district_id`, `monthupdated`(50), `yearupdated`(50))');
        $db->query('ALTER TABLE `children_6m_3y` ADD INDEX `idx_age_optout` (`age_in_months`, `snp_opt_out`)');
        $db->query('ALTER TABLE `children_6m_3y` ADD INDEX `idx_district_age` (`district_id`, `age_in_months`, `snp_opt_out`, `monthupdated`(50), `yearupdated`(50))');
        $db->query('ALTER TABLE `children_6m_3y` ADD INDEX `idx_age_range` (`age_in_months`, `district_id`, `snp_opt_out`)');
        $db->query('ALTER TABLE `children_6m_3y` ADD INDEX `idx_children_6m_3y_join` (`awc_name`(50), `monthupdated`(50), `yearupdated`(50))');
        $db->query('ALTER TABLE `children_6m_3y` ADD INDEX `idx_age_months` (`age_in_months`)');
        $db->query('ALTER TABLE `children_6m_3y` ADD INDEX `idx_districtname_month_year_optout` (`DistrictName`(100), `monthupdated`(50), `yearupdated`(50), `snp_opt_out`)');
        $db->query('ALTER TABLE `children_6m_3y` ADD INDEX `idx_sector_awc_month_year_optout_6m3y` (`sector_id`, `awc_code`(50), `monthupdated`(50), `yearupdated`(50), `snp_opt_out`)');

    }

    public function down()
    {
        $this->forge->dropTable('children_6m_3y');
    }
}
