<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class CreateChildren3y6yTable extends Migration
{
    public function up()
    {
        $this->forge->addField([
            'child_id' => [
                'type'           => 'INT',
                'constraint'     => 11,
                'auto_increment' => true,
            ],
            'id' => [
                'type'       => 'VARCHAR',
                'constraint' => '255',
                'null'       => true,
            ],
            'ProjectName' => [
                'type'       => 'VARCHAR',
                'constraint' => '255',
                'null'       => true,
            ],
            'DistrictName' => [
                'type'       => 'VARCHAR',
                'constraint' => '255',
                'null'       => true,
            ],
            'ProjectCode' => [
                'type'       => 'VARCHAR',
                'constraint' => '255',
                'null'       => true,
            ],
            'monthupdated' => [
                'type'       => 'INT',
                'constraint' => 11,
                'null'       => true,
            ],
            'yearupdated' => [
                'type'       => 'INT',
                'constraint' => 11,
                'null'       => true,
            ],
            'created_at' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'aadhar_flag' => [
                'type'       => 'VARCHAR',
                'constraint' => '255',
                'null'       => true,
            ],
            'aadhar_verified' => [
                'type'       => 'VARCHAR',
                'constraint' => '255',
                'null'       => true,
            ],
            'abha_address' => [
                'type'       => 'VARCHAR',
                'constraint' => '255',
                'null'       => true,
            ],
            'abha_id' => [
                'type'       => 'VARCHAR',
                'constraint' => '255',
                'null'       => true,
            ],
            'awc_code' => [
                'type'       => 'VARCHAR',
                'constraint' => '255',
                'null'       => true,
            ],
            'awc_id' => [
                'type'       => 'VARCHAR',
                'constraint' => '255',
                'null'       => true,
            ],
            'awc_name' => [
                'type'       => 'VARCHAR',
                'constraint' => '255',
                'null'       => true,
            ],
            'beneficiary_type' => [
                'type'       => 'VARCHAR',
                'constraint' => '255',
                'null'       => true,
            ],
            'category' => [
                'type'       => 'VARCHAR',
                'constraint' => '255',
                'null'       => true,
            ],
            'district_id' => [
                'type'       => 'VARCHAR',
                'constraint' => '255',
                'null'       => true,
            ],
            'dob' => [
                'type'       => 'VARCHAR',
                'constraint' => '255',
                'null'       => true,
            ],
            'father_name' => [
                'type'       => 'VARCHAR',
                'constraint' => '255',
                'null'       => true,
            ],
            'gender' => [
                'type'       => 'VARCHAR',
                'constraint' => '255',
                'null'       => true,
            ],
            'mobile_no' => [
                'type'       => 'VARCHAR',
                'constraint' => '255',
                'null'       => true,
            ],
            'mobile_verified' => [
                'type'       => 'VARCHAR',
                'constraint' => '255',
                'null'       => true,
            ],
            'mother_name' => [
                'type'       => 'VARCHAR',
                'constraint' => '255',
                'null'       => true,
            ],
            'name' => [
                'type'       => 'VARCHAR',
                'constraint' => '255',
                'null'       => true,
            ],
            'project_id' => [
                'type'       => 'VARCHAR',
                'constraint' => '255',
                'null'       => true,
            ],
            'school_going' => [
                'type'       => 'VARCHAR',
                'constraint' => '255',
                'null'       => true,
            ],
            'sector_id' => [
                'type'       => 'VARCHAR',
                'constraint' => '255',
                'null'       => true,
            ],
            'sector_name' => [
                'type'       => 'VARCHAR',
                'constraint' => '255',
                'null'       => true,
            ],
            'snp_opt_out' => [
                'type'       => 'VARCHAR',
                'constraint' => '255',
                'null'       => true,
            ],
            'snp_opt_out_date' => [
                'type'       => 'VARCHAR',
                'constraint' => '255',
                'null'       => true,
            ],
            'state_id' => [
                'type'       => 'VARCHAR',
                'constraint' => '255',
                'null'       => true,
            ],
            'uid_hash' => [
                'type'       => 'VARCHAR',
                'constraint' => '255',
                'null'       => true,
            ],
            'updated_at' => [
                'type'       => 'VARCHAR',
                'constraint' => '255',
                'null'       => true,
            ],
            'age_in_months' => [
                'type'       => 'INT',
                'constraint' => 11,
                'null'       => true,
            ],
            'encrypted_u_id' => [
                'type'       => 'VARCHAR',
                'constraint' => '255',
                'null'       => true,
            ],
            'birth_weight' => [
                'type'       => 'DECIMAL',
                'constraint' => '5,2',
                'null'       => true,
            ],
            'current_weight' => [
                'type'       => 'DECIMAL',
                'constraint' => '5,2',
                'null'       => true,
            ],
            'weight_captured_date' => [
                'type' => 'DATE',
                'null' => true,
            ],
            'encrypted_mobile' => [
                'type'       => 'VARCHAR',
                'constraint' => '255',
                'null'       => true,
            ],
            'ProjectID' => [
                'type'       => 'VARCHAR',
                'constraint' => '50',
                'null'       => true,
            ],
            'face_verified' => [
                'type'       => 'VARCHAR',
                'constraint' => '255',
                'null'       => true,
            ],
            'apaar_id' => [
                'type'       => 'VARCHAR',
                'constraint' => '255',
                'null'       => true,
            ],
        ]);
        
        // Primary key
        $this->forge->addKey('child_id', true);
        
        $this->forge->createTable('children_3y_6y');
        
        // Add indexes with length prefixes using raw SQL
        $db = \Config\Database::connect();
        
        $db->query('ALTER TABLE `children_3y_6y` ADD INDEX `idx_id` (`id`(50))');
        $db->query('ALTER TABLE `children_3y_6y` ADD INDEX `idx_date` (`monthupdated`, `yearupdated`)');
        $db->query('ALTER TABLE `children_3y_6y` ADD INDEX `idx_search` (`ProjectCode`(50), `monthupdated`, `yearupdated`)');
        $db->query('ALTER TABLE `children_3y_6y` ADD INDEX `idx_project_name` (`ProjectName`(50))');
        $db->query('ALTER TABLE `children_3y_6y` ADD INDEX `idx_project_month_year` (`ProjectCode`(50), `monthupdated`, `yearupdated`)');
        $db->query('ALTER TABLE `children_3y_6y` ADD INDEX `idx_district_Id_month_year` (`district_id`(50), `monthupdated`, `yearupdated`, `snp_opt_out`(50))');
        $db->query('ALTER TABLE `children_3y_6y` ADD INDEX `idx_district_age` (`district_id`(50), `snp_opt_out`(50), `monthupdated`, `yearupdated`)');
        $db->query('ALTER TABLE `children_3y_6y` ADD INDEX `idx_awc_code_month_year` (`awc_code`(50), `snp_opt_out`(50), `monthupdated`, `yearupdated`)');
        $db->query('ALTER TABLE `children_3y_6y` ADD INDEX `awc_code_monthupdated_yearupdated` (`awc_code`(50), `monthupdated`, `yearupdated`)');
        $db->query('ALTER TABLE `children_3y_6y` ADD INDEX `idx_awc_code` (`awc_code`(50))');
        $db->query('ALTER TABLE `children_3y_6y` ADD INDEX `idx_districtname_month_year_optout` (`DistrictName`(50), `monthupdated`, `yearupdated`, `snp_opt_out`(50))');
        $db->query('ALTER TABLE `children_3y_6y` ADD INDEX `idx_sector_awc_month_year_optout_3y6y` (`sector_id`(50), `awc_code`(50), `monthupdated`, `yearupdated`, `snp_opt_out`(50))');
    }

    public function down()
    {
        $this->forge->dropTable('children_3y_6y');
    }
}
