<?php

namespace App\Models;

use CodeIgniter\Model;

class AnganwadiNamesModel extends Model
{
    protected $table            = 'anganwadi_names';
    protected $primaryKey       = 'id';
    protected $useAutoIncrement = true;
    protected $returnType       = 'array';
    protected $useSoftDeletes   = false;
    protected $protectFields    = true;
    protected $allowedFields    = [
        'district_id',
        'awc_center_code',
        'name'
    ];

    // Get anganwadi centers by district_id
    public function getByDistrictId($districtId)
    {
        return $this->where('district_id', $districtId)
                    ->orderBy('name', 'ASC')
                    ->findAll();
    }

    // Get anganwadi center by awc_center_code
    public function getByAwcCode($awcCode)
    {
        return $this->where('awc_center_code', $awcCode)->first();
    }
}
