<?php

namespace App\Models;

use CodeIgniter\Model;

class Children0m6mModel extends Model
{
    protected $table            = 'children_0m_6m';
    protected $primaryKey       = 'child_Id';
    protected $useAutoIncrement = true;
    protected $returnType       = 'array';
    protected $useSoftDeletes   = false;
    protected $protectFields    = true;
    protected $allowedFields    = [
        'ProjectName',
        'DistrictName',
        'abha_address',
        'abha_id',
        'aadhar_flag',
        'aadhar_verified',
        'awc_id',
        'awc_name',
        'beneficiary_type',
        'category',
        'district_id',
        'dob',
        'father_name',
        'gender',
        'id',
        'mobile_no',
        'mobile_verified',
        'mother_name',
        'name',
        'project_id',
        'sector_id',
        'sector_name',
        'state_id',
        'updated_at',
        'awc_code',
        'uid_hash',
        'ProjectCode',
        'monthupdated',
        'yearupdated',
        'age_in_months',
        'snp_opt_out',
        'birth_weight',
        'current_weight',
        'weight_captured_date',
        'encrypted_u_id',
        'encrypted_mobile',
        'face_verified'
    ];

    // Get children by awc_code
    public function getByAwcCode($awcCode)
    {
        return $this->where('awc_code', $awcCode)->findAll();
    }
}
