<?php

namespace App\Models;

use CodeIgniter\Model;

class DistrictModel extends Model
{
    protected $table            = 'district';
    protected $primaryKey       = 'id';
    protected $useAutoIncrement = true;
    protected $returnType       = 'array';
    protected $useSoftDeletes   = false;
    protected $protectFields    = true;
    protected $allowedFields    = [
        'district_id',
        'district_name'
    ];

    // Get all districts ordered by name
    public function getAllDistricts()
    {
        return $this->orderBy('district_name', 'ASC')->findAll();
    }

    // Get district by district_id
    public function getByDistrictId($districtId)
    {
        return $this->where('district_id', $districtId)->first();
    }
}
