<?php

use CodeIgniter\Router\RouteCollection;

/**
 * @var RouteCollection $routes
 */
$routes->get('/', 'Home::index');

// Authentication routes
$routes->get('/auth', 'Auth::index');
$routes->get('/login', 'Auth::index');
$routes->post('/auth/login', 'Auth::login');
$routes->post('/auth/refreshCaptcha', 'Auth::refreshCaptcha');
$routes->get('/logout', 'Auth::logout');

// Dashboard routes (protected)
$routes->get('/dashboard', 'Home::dashboard');
$routes->get('/admin/dashboard', 'Home::adminDashboard');
$routes->get('/district/dashboard', 'Home::districtDashboard');
$routes->get('/block/dashboard', 'Home::blockDashboard');
$routes->get('/supervisor/dashboard', 'Home::supervisorDashboard');
