<?php

namespace App\Controllers;

class Home extends BaseController
{
    public function index(): string
    {
        return view('welcome_message');
    }

    public function dashboard()
    {
        if (!session('logged_in')) {
            return redirect()->to('/auth');
        }
        
        $data = [
            'user_type' => session('user_type'),
            'district' => session('district')
        ];
        
        return view('dashboard', $data);
    }

    public function adminDashboard()
    {
        if (!session('logged_in') || session('user_type') !== 'admin') {
            return redirect()->to('/auth');
        }
        
        $data = [
            'user_type' => session('user_type'),
            'district' => session('district')
        ];
        
        return view('admin/dashboard', $data);
    }

    public function districtDashboard()
    {
        if (!session('logged_in') || session('user_type') !== 'district') {
            return redirect()->to('/auth');
        }
        
        $data = [
            'user_type' => session('user_type'),
            'district' => session('district')
        ];
        
        return view('district/dashboard', $data);
    }

    public function blockDashboard()
    {
        if (!session('logged_in') || session('user_type') !== 'block') {
            return redirect()->to('/auth');
        }
        
        $data = [
            'user_type' => session('user_type'),
            'district' => session('district')
        ];
        
        return view('block/dashboard', $data);
    }

    public function supervisorDashboard()
    {
        if (!session('logged_in') || session('user_type') !== 'supervisor') {
            return redirect()->to('/auth');
        }
        
        $data = [
            'user_type' => session('user_type'),
            'district' => session('district')
        ];
        
        return view('supervisor/dashboard', $data);
    }
}
