<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class CreateTblTypeUser extends Migration
{
    public function up()
    {
        $this->forge->addField([
            'id' => [
                'type'           => 'INT',
                'constraint'     => 11,
                'unsigned'       => true,
                'auto_increment' => true,
            ],
            'type_user' => [
                'type'       => 'VARCHAR',
                'constraint' => 211,
            ],
            'role' => [
                'type'       => 'INT',
                'constraint' => 11,
            ],
        ]);

        $this->forge->addPrimaryKey('id');
        $this->forge->createTable('tbl_type_user', true);
    }

    public function down()
    {
        $this->forge->dropTable('tbl_type_user');
    }
}
