<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>ICPS</title>
  <link rel="icon" type="image/png" href="<?= base_url(); ?>assets/images/haryanalogo.png" />
  <link rel="stylesheet" href="<?= base_url('assets/css/bootstrap.min.css'); ?>" />
  <link rel="stylesheet" href="<?= base_url('assets/css/all.min.css'); ?>" />
  <style>
    html,
    body {
      margin: 0;
      padding: 0;
      height: 100%;
      width: 100%;
      font-family: Arial, sans-serif;
      font-size: small;
    }

    .form-group {
      margin-bottom: 20px;
    }

    .form-label {
      font-weight: 400;
      color: #000;
    }

    .form-control {
      border-radius: 5px;
      color: #000;
    }

    .btn-submit:hover {
      background-color: #0056b3;
    }

    .red_impo {
      color: red;
    }

    .input-group-text {}

    .input-group .form-control {
      border-left: none;
    }

    .text-danger {
      font-size: 0.875rem;
    }

    .header {
      background: #ffc10738;
      padding: 10px 0;
    }

    .header .container {
      display: flex;
      align-items: center;
      justify-content: space-between;
    }

    .header .logo {
      height: 100px;
    }

    .header .title {
      font-size: 27px;
      margin: 0;
    }

    .header .subtitle {
      font-size: 18px;
      margin: 0;
      color: #f1f1f1;
      /* Adjust as needed */
    }

    footer {
      background-color: #002139;
      padding: 10px 0px 10px 0px;
    }

    footer ul.footer-site-links li::after {
      position: absolute;
      content: "|";
      right: 0;
      font-size: 15px;
    }

    footer ul.footer-site-links li {
      position: relative;
      padding: 0 10px;
      color: rgb(255, 255, 255);
      display: inline-flex;
      align-items: center;
    }

    footer ul.footer-site-links li a {
      font-size: 15px;
      color: rgb(255, 255, 255);
      transition: 0.3s ease-in-out;
    }

    .copyRightsText p {
      margin: 5px 0;
      font-size: 14px;
      color: #333;
    }

    .copyRightsLogos img {
      height: 30px;
      margin-right: 10px;
    }

    .h1-logo {
      font-style: normal;
      font-size: 1.75em;
      margin: 0;
      font-weight: 700;
    }

    .btnclass {
      width: 30%;
    }

    .form-control::placeholder {
      color: #000 !important;
    }

    @media (max-width: 767px) {
      .header .logo {
        height: 50px;
        /* Adjust as needed for smaller screens */
      }

      .header .title {
        font-size: 18px;
      }

      .header .subtitle {
        font-size: 14px;
      }

      .copyRightsText p {
        font-size: 12px;
      }

      .copyRightsLogos img {
        height: 20px;
        /* Adjust as needed for smaller screens */
      }
    }

    .form-container {

      max-width: 650px;
      margin: auto;
      padding: 20px;
    }

    .form-header {
      text-align: center;
    }

    .error {
      color: red;
      font-size: 0.875em;
      margin-top: 0.25rem;
    }

    footer ul.footer-site-links li {
      position: relative;
      color: rgb(255, 255, 255);
      display: inline-flex;
      align-items: center;
    }

    footer ul.footer-site-links {
      justify-content: center;
      margin: 0;
      flex-wrap: wrap;
      border-bottom: 1px solid rgba(255, 255, 255, 0.5);
      padding-bottom: 20px;
      margin-bottom: 15px;
    }

    footer p.footer-text {
      text-align: center;
      color: rgb(255, 255, 255);
      font-size: 14px;
    }
  </style>
</head>

<body>
  <header class="header">
    <div class="container-fluid">
      <div class="row align-items-center">
        <div class="col-md-2 text-right">
          <img src="<?= base_url('assets/images/haryanalogo.png'); ?>" alt="Left Logo" class="logo">
        </div>
        <div class="col-md-8 d-flex flex-column align-items-center text-center">
          <!-- <h1 class="title text-white h1-logo">Mission Vatsalya - Bal Sanrakshan</h1> -->
          <h1 class="title h1-logo" style="font-size: 40px">बाल संरक्षण</h1>
          <h6 class="" style="font-size: 18px">महिला एवं बाल विकास विभाग, हरियाणा</h6>
          <!-- <h6 class="subtitle text-white">Department of Women and Child Development, Haryana</h6> -->
        </div>
        <div class="col-md-2 text-right" style="    margin-left: -51px;">
          <img src="<?= base_url('assets/images/left-logo.png'); ?>" alt="Right Logo" class="logo">
        </div>
      </div>
    </div>
  </header>

  <div class="container-fluid" style="background-image: url('<?= base_url('assets/images/crime.jpg'); ?>');background-size: cover;
         background-position: center;
         background-repeat: no-repeat;">
    <div class="form-container">
      <div class="card" style="background-color: rgb(26 14 9 / 82%);">
        <div class="card-body">
          <h2 class="form-header text-center text-white">Department Login</h2>

          <form action="<?= site_url('auth/login') ?>" method="POST" id="loginForm">
            <?= csrf_field() ?>
            <fieldset style="padding: 20px;">
              <!-- User Type Dropdown -->
              <div class="row">
                <div class="form-group col-sm-3">
                  <label for="user_type" class="control-label text-white" style="font-weight: 700;">
                    User Type <span class="red_impo">*</span>
                  </label>
                </div>
                <div class="form-group col-sm-9">
                  <select class="form-control form-select border-inline type_user boxback" required="required"
                    name="type_user">
                    <option value="">Select User</option>
                    <?php if (isset($userTypes) && !empty($userTypes)): ?>
                      <?php foreach ($userTypes as $userType): ?>
                        <option value="<?= esc($userType['id']) ?>" data-role="<?= esc($userType['role']) ?>">
                          <?= esc($userType['type_user']) ?>
                        </option>
                      <?php endforeach; ?>
                    <?php endif; ?>
                  </select>
                </div>
              </div>

              <!-- District Dropdown -->
              <div class="row districtselects">
                <div class="form-group col-sm-3">
                  <label class="control-label text-white" style="font-weight: 700;">
                    District <span class="red_impo"> *</span>
                  </label>
                </div>
                <div class="form-group col-sm-9">
                  <select class="form-control form-select border-inline boxback district" required="required"
                    name="district">
                    <option value="">Select District</option>
                    <?php if (isset($districts) && !empty($districts)): ?>
                      <?php foreach ($districts as $district): ?>
                        <option value="<?= esc($district['District_code']) ?>"
                          data-state="<?= esc($district['State_code']) ?>">
                          <?= esc($district['District_Name']) ?>
                        </option>
                      <?php endforeach; ?>
                    <?php endif; ?>
                  </select>
                </div>
              </div>

              <div class="row cci_div">
                <div class="form-group col-sm-3">
                  <label class="control-label text-white" style="font-weight: 700;">
                    CCI <span class="red_impo">*</span>
                  </label>
                </div>
                <div class="form-group col-sm-9">
                  <select class="form-control mb-3 form-select border-inline cci_name boxback" required="required"
                    name="cci_name">
                    <option value="">Select CCI</option>
                  </select>
                </div>
              </div>

              <!-- Password Field -->
              <div class="row">
                <div class="form-group col-sm-3">
                  <label for="password" class="text-white" style="font-weight: 700;">
                    Password <span class="red_impo">*</span>
                  </label>
                </div>
                <div class="form-group col-sm-9">
                  <input id="password" class="form-control border-inline boxback" name="password" type="password"
                    autocomplete="off" placeholder="Enter your password">
                </div>
              </div>


              <!-- Captcha Section -->
              <div class="row">
                <div class="form-group col-md-3">
                  <div
                    style="background-color: #007bff; color: white; padding: 10px; text-align: center; font-weight: bold; letter-spacing: 3px; border-radius: 5px;">
                    <span id="captcha-code"><?= session('captcha_code') ?? '39XWGI' ?></span>
                  </div>
                </div>
                <div class="form-group col-md-9">
                  <input type="text" class="form-control" id="captcha" name="captcha" placeholder="Enter captcha code"
                    required>
                </div>
              </div>
        </div>

        <!-- Login Button -->
        <div class="form-group text-center">
          <button type="submit" class="btn btn-success btn-lg" style="width: 200px;">Login</button>
        </div>
        </fieldset>

        <!-- Error Messages -->
        <?php if (session('error')): ?>
          <div class="alert alert-danger text-center">
            <?= session('error') ?>
          </div>
        <?php endif; ?>
        </form>
      </div>
    </div>
  </div>
  </div>

  <footer>
    <div class="container">
      <div class="row">
        <div class="col-12">
          <ul class="footer-site-links text-center">
            <li><a href="#" target="_blank" title="Home">Home</a></li>
            <li>
              <a href="https://wcdhry.gov.in" target="_blank">WCD, Haryana</a>
            </li>

            <li>
              <a href="https://missionvatsalya.wcd.gov.in/" target="_blank">Mission Vatsalya</a>
            </li>
            <li>
              <a href="https://wcdhry.gov.in/contact-us/" target="_blank">Contact Us</a>
            </li>
          </ul>
          <p class="footer-text">Website Content Managed by Women and Child Development Department, Government of
            Haryana. Copyright WCD © <?= date('Y') ?>. All rights reserved.</p>
          <div class="footer-site-counter">
          </div>
        </div>
      </div>
    </div>
  </footer>

  <script src="<?= base_url(); ?>assets/newstyle/assets/js/bootstrap.bundle.min.js"></script>
  <script>
    $(document).ready(function () {
      $('.cci_div').hide();

      // Show/hide CCI section based on User Type
      $('.type_user').on('change', function () {
        var userType = $(this).val();
        if (userType == "6") {
          $('.cci_div').show();
        } else {
          $('.cci_div').hide();
          $('.cci_name').val(""); // Optional: reset CCI dropdown
        }
      });
      $('.district').on('change', function () {
        var districtCode = $(this).val();

        if (districtCode !== "") {
          $.ajax({
            url: "<?= base_url('Login/get_ccis_by_district') ?>",
            type: "POST",
            data: { district_code: districtCode },
            dataType: "json",
            success: function (response) {
              var cciSelect = $('.cci_name');
              cciSelect.empty().append('<option value="">Select CCI</option>');
              if (response.length > 0) {
                $('.cci_div').show();
                $.each(response, function (index, cci) {
                  cciSelect.append('<option value="' + cci.cci_name + '">' + cci.cci_name + '</option>');
                });
              } else {
                $('.cci_div').hide();
              }
            }
          });
        } else {
          $('.cci_div').hide();
          $('.cci_name').empty().append('<option value="">Select CCI</option>');
        }
      });
    });
  </script>
  <script>
    // Generate random captcha
    function generateCaptcha() {
      const chars = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789';
      let result = '';
      for (let i = 0; i < 6; i++) {
        result += chars.charAt(Math.floor(Math.random() * chars.length));
      }
      return result;
    }

    // Refresh captcha
    function refreshCaptcha() {
      const newCaptcha = generateCaptcha();
      document.getElementById('captcha-code').textContent = newCaptcha;
      // Send new captcha to session via AJAX
      fetch('<?= site_url('auth/refreshCaptcha') ?>', {
        method: 'POST',
        headers: {
          'Content-Type': 'application/json',
          'X-CSRF-TOKEN': document.querySelector('input[name="<?= csrf_token() ?>"]').value
        },
        body: JSON.stringify({ captcha: newCaptcha })
      });
    }

    // Initialize captcha on page load
    document.addEventListener('DOMContentLoaded', function () {
      refreshCaptcha();

      // Add click event to captcha for refresh
      document.getElementById('captcha-code').addEventListener('click', refreshCaptcha);
      document.getElementById('captcha-code').style.cursor = 'pointer';
      document.getElementById('captcha-code').title = 'Click to refresh captcha';
    });

    // Form validation
    document.getElementById('loginForm').addEventListener('submit', function (e) {
      const userType = document.getElementById('user_type').value;
      const district = document.getElementById('district').value;
      const password = document.getElementById('password').value;
      const captcha = document.getElementById('captcha').value;
      const captchaCode = document.getElementById('captcha-code').textContent;

      if (!userType || !district || !password || !captcha) {
        e.preventDefault();
        alert('Please fill all required fields');
        return false;
      }

      if (captcha.toUpperCase() !== captchaCode.toUpperCase()) {
        e.preventDefault();
        alert('Invalid captcha code');
        return false;
      }
    });
  </script>
</body>

</html>